# Generated by Django 4.0.3 on 2022-06-07 14:47

from django.db import migrations, models
import django.db.models.deletion
import django_countries.fields


class Migration(migrations.Migration):

    dependencies = [
        ('links_manager', '0008_alter_link_max_clicks'),
    ]

    operations = [
        migrations.AlterField(
            model_name='link',
            name='max_clicks',
            field=models.IntegerField(default=0, help_text="The link won't be accessable after reaching the maximum clicks amount or redirect to a different URL.<br><b>(0 value means unlimited clicks!)</b>.", verbose_name='Maximum Clicks'),
        ),
        migrations.CreateModel(
            name='Targeting',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('country', django_countries.fields.CountryField(db_index=True, max_length=2)),
                ('device', models.IntegerField(choices=[(0, '(any device)'), (1, 'Desktop'), (2, 'Mobile'), (3, 'Tablet')], db_index=True, default=0)),
                ('platform', models.IntegerField(choices=[(0, '(any platform)'), (1, 'Windows'), (2, 'Linux'), (3, 'Android'), (4, 'MacOS'), (5, 'iOS')], db_index=True, default=0)),
                ('link', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='links_manager.link')),
            ],
        ),
    ]
